/*------------------------------------------------------------------------------*
 * File Name: RangeBrowser.h 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Folger 07/17/07 IMPLEMENT_DIALOG_FUNCTION									*
 * Folger 07/17/07 CLEAN_UP_DUPLICATED_CODES_IN_PROJECT_BROWSER_RANGE_BROWSER	*
 * Jasmine 07/18/07 SET_SHOW_COLUMN_WITH_VECTOR_UINT							*
 * Jasmine 07/18/07 COLUMN_LIST_MENU											*
 * Folger 07/19/07 ADD_STATUS_BAR_FOR_RANGE_BROWSER								*
 * Folger 07/19/07 SET_COMBO_LIST_CURRENT_SELECTED								*
 * Folger 07/19/07 ON_SELECTED_LIST_SELECTION_CHANGE							*
 * Jasmine 07/23/07 ADD_PLOT_LIST_CLASS											*
 * Folger 07/24/07 CLEAN_UP_DATAPLOT_RANGE_STRING_CODE							*
 * Folger 07/25/07 UNIFY_PBLIST_MENU_BY_ADD_LOWERBOUND_AND_UPPERBOUND			*
 * Folger 07/26/07 FIX_BUGS_IN_REFRESH_TOP_PANEL								*
 * Folger 07/31/07 NOT_SHOW_BOOK_SHEET_WHEN_INIT_FROM_GRAPH						*
 * Folger 07/31/07 HIDE_FILTER_BUTTON											*
 * Folger 08/01/07 SAVE_HIDE_COLS_WHEN_DATASET_TAB_CHANGE						*
 * Folger 08/02/07 UPDATE_RANGE_SELECTION_VECTOR_STRING_AFTER_DARG&DROP			*
 * Folger 08/03/07 STATUS_BAR_RESIZE_WHEN_DIALOG_RESIZE							*
 * Folger 08/09/07 UPDATE_STATUS_BAR_WHEN_SELECTION_CHANGE						*
 * Folger 08/09/07 SHOW_INFO_STRING_WHEN_NO_DATASET_SELECTED_IN_BOTTOM_PANEL	*
 * Folger 08/09/07 SET_BOTTOM_PANEL_BY_ACTIVE_ORIOBJ_ONLY						*
 * Folger 08/23/07 FIX_BUGS_WHEN_PAGE_INVALID									*
 * Jasmine 09/28/07 QA70-10305 FILTER_OUT_NON_IMAGE_MATRIX						*
 * Jasmine 09/28/07 QA70-10305 CHECK_SINGLE_SELECT_MODE							*
 * Folger 10/26/07 CORRECT_NAME_SHOWN_IN_RANGE_BROWSER							*
 * Folger 11/13/07 FIX_BUG_OF_COMBO_LSIT_ARRANGEMENT_IN_DATASET_BROWSER			*
 * Fisher 11/15/07 ADD_MAP_ID_TO_CHM											*
 * Kyle 06/30/2009 RANGE_BROWSER_SHOULD_KEEP_LAST_SELECT_IN_FILTER_COMBO_BOX	*
 *	Kenny 09/10/2009 QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS			*
 *	Kenny 09/18/2009 INSERT_MODE_COMBO_TOO_NARROW								*
 *	Folger 10/28/09 SPECIFY_LOCALIZATION_CATEGORY_FOR_RANGE_BROWSER				*
 * Jasmine 04/20/10 QA81-15333-P2 CHECK_AND_ADD_COMBO_ITEM_TO_SELECT			*
 * Jasmine 04/20/10 QA81-15333-P2 PBLIST_IS_INVALID_IF_NO_INIT_AND_LEAD_TO_RUNTIME_ERR
 *	Folger 06/01/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT						*
 *------------------------------------------------------------------------------*/
 
#ifndef _RANGE_BROWSER_H
#define _RANGE_BROWSER_H

/// Kenny 09/11/2009 QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
#include <event_utils.h>
/// End QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS

///------ Folger 10/28/09 SPECIFY_LOCALIZATION_CATEGORY_FOR_RANGE_BROWSER
#define STR_CATEGORY		"Range Browser"
#define STR_ADD				_LC("Add", STR_CATEGORY)
#define STR_REPLACE			_LC("Replace", STR_CATEGORY)
///------ End SPECIFY_LOCALIZATION_CATEGORY_FOR_RANGE_BROWSER

#define STR_DLG_NAME 		_L("Range Browser")
#define STR_FILTER_TEXT		_L("It's not case sensitive; \"*\" matches any substring; \"?\" matches any character\nFor example: L = \"Fit*\" && UDL1 = \"07/0?/07\"")
		
enum{
	LIST_ALL_IN_PROJECT,
	LIST_ALL_IN_FOLDER,
	LIST_ALL_IN_PAGE,
	LIST_ALL_IN_LAYER,
	LIST_ALL_IN_GRAPH
};
//------ Folger 10/26/07 CORRECT_NAME_SHOWN_IN_RANGE_BROWSER
#define STR_DATASET_SELECTED	_L("Dataset Selected")
#define STR_COLUMN_SELECTED		_L("Column Selected")
#define STR_MATRIX_SELECTED		_L("Matrix Selected")
#define STR_IMAGE_SELECTED		_L("Image Selected")
//------ End  CORRECT_NAME_SHOWN_IN_RANGE_BROWSER
class FilterEditDlg : public ResizeDialog
{
private:
	string 	m_strFilter;
	bool 	m_bResizeFirstTime;	
public:
	FilterEditDlg() : ResizeDialog(IDD_MULTI_EDIT_BOX, "ODlg8")
	{
	}
	int  DoModalEx(HWND hParent = NULL) 
	{
		InitMsgMap();
		int nRet = ResizeDialog::DoModal(hParent);
		return nRet;
	}
	string GetText()
	{
		return m_strFilter;
	}	
protected:
	EVENTS_BEGIN
		ON_INIT(OnInitDialog) 
		ON_SIZE(OnDlgResize)
		ON_DESTROY(OnDestroy)
		ON_BN_CLICKED(IDOK, OnOK)

	EVENTS_END		
	

	
	
	BOOL OnInitDialog() 
	{
		Text = _L("Filter");
		ResizeDialog::OnInitDialog();
		
		GetItem(IDC_APPLY_BTN).Visible = false;
		GetItem(IDC_HINTS_TEXT).Visible = true;
		GetItem(IDC_HINTS_TEXT).Text = STR_FILTER_TEXT;
		m_bResizeFirstTime = true;
		return TRUE;
	}
	BOOL OnDlgResize(int nType, int cx, int cy)
	{
		uint nBottomIDs[]  = {IDCANCEL, IDOK, 0};
		ArrangeMainItemAndControls(nBottomIDs, IDC_EDIT_BOX, NULL, false);
		
		RECT rrText, rrEdit;
		GetClientRect(GetItem(IDC_EDIT_BOX), rrEdit);
		GetClientRect(GetItem(IDC_HINTS_TEXT), rrText);
		rrText.right = rrEdit.right;
		
		if(m_bResizeFirstTime)
		{
			rrEdit.top = rrText.bottom + GetControlGap();
			MoveControl(GetItem(IDC_EDIT_BOX), rrEdit); 				
			m_bResizeFirstTime = false;
		}
		MoveControl(GetItem(IDC_HINTS_TEXT), rrText); 
		return true;
	}
	BOOL OnOK(Control cntrl)
	{
		m_strFilter = GetItem(IDC_EDIT_BOX).Text;
		return TRUE;
	}
};

/// Kenny 09/11/2009 QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
enum
{
	RNGBROWSER_ENABLE_INSERT_MODE	= 0x00000001,
};
/// End QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS

class RangeListDlg : public MultiPaneDlg
{
public:
	//RangeListDlg(int nPageType, bool bXYRange = false, bool bMultipleSelect = true, bool bResultSheet = false, LPCSTR lpcszDlg = NULL) : MultiPaneDlg(IDD_REPORT_TREE_DLG, "ODlg8")
	/// Kenny 09/11/2009 QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
	//RangeListDlg(int nPageType, bool bXYRange = false, bool bMultipleSelect = true, DWORD dwFilter = 0, LPCSTR lpcszDlg = NULL) : MultiPaneDlg(IDD_REPORT_TREE_DLG, "ODlg8")
	///------ Folger 06/01/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT
	//RangeListDlg(int nPageType, bool bXYRange = false, bool bMultipleSelect = true, DWORD dwFilter = 0, LPCSTR lpcszDlg = NULL, DWORD dwCtrls = 0) : MultiPaneDlg(IDD_REPORT_TREE_DLG, "ODlg8")
	RangeListDlg(int nPageType, bool bXYRange = false, bool bMultipleSelect = true, DWORD dwFilter = 0, LPCSTR lpcszDlg = NULL, DWORD dwCtrls = 0
		, LPCSTR lpcszBookSheetSpecified = NULL
		)
		: MultiPaneDlg(IDD_REPORT_TREE_DLG, "ODlg8")
	///------ End DATA_DISPLAY_DIALOG_IMPROVEMENT
	/// End QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
	{
		m_nPageFilterType = nPageType;
		m_bXYRange = bXYRange;
		m_nSelectMode = bMultipleSelect? MULTIPLE_SELECT : SINGLE_SELECT;		//-------Folger 07/17/07 IMPLEMENT_DIALOG_FUNCTION		
		m_dwFilter = dwFilter;//m_bResultSheet = bResultSheet;	///Jasmine 09/28/07 FILTER_OUT_NON_IMAGE_MATRIX	
		m_strDlgName = STR_DLG_NAME;
		if(lpcszDlg)
			m_strDlgName = lpcszDlg;

		m_nSel = -1;			///Kyle 06/30/2009 RANGE_BROWSER_SHOULD_KEEP_LAST_SELECT_IN_FILTER_COMBO_BOX

		/// Kenny 09/10/2009 QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
		m_bShowInsertMode	= dwCtrls & RNGBROWSER_ENABLE_INSERT_MODE;
		/// End QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS

		///------ Folger 06/01/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT
		m_strBookSheetSpecified = lpcszBookSheetSpecified;
		///------ End DATA_DISPLAY_DIALOG_IMPROVEMENT
	}
	int  DoModalEx(HWND hParent = NULL) 
	{
		InitMsgMap();
		int nRet = MultiPaneDlg::DoModal(hParent);
		return nRet;
	}
	void SetSelectedItems(const vector<string>& vsSelection = NULL)
	{
		if(NULL != vsSelection)
			m_vsSelection = vsSelection;
	}
	int GetSelectedItems(vector<string>& vsResult)
	{
		vsResult = m_vsSelection;
		return vsResult.GetSize();
	}

	/// Kenny 09/10/2009 QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
	int GetInsertMode()
	{
		return m_nInsertMode;
	}
	/// End QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
	
	protected :	
EVENTS_BEGIN
	ON_INIT(OnInitDialog) 
	ON_DESTROY(OnDestroy)
	ON_READY(OnReady)
	ON_SIZE(OnDlgResize)
	ON_INIT_SIZE(OnInitSize)
	ON_RESTORESIZE(OnRestoreSize)
	ON_SYSCOMMAND(OnSystemCommand)//make min button to rollup dialog
	ON_BN_CLICKED(IDC_FILTER_BTN, OnFilter)
	ON_BN_CLICKED(IDC_EXCLUDE_BTN, OnExclude)
	//-------Folger 07/17/07 IMPLEMENT_DIALOG_FUNCTION
	ON_BN_CLICKED(IDC_ADD_BTN, OnAdd)
	ON_BN_CLICKED(IDC_REMOVE_BTN, OnRemove)
	ON_GRID_DBLCLICK(IDC_REPORT_TREE_LIST, OnDoubleClick)
	//-------End IMPLEMENT_DIALOG_FUNCTION
	ON_BN_CLICKED(IDC_SHOW_HIDE_BTN, OnShowBottomPane)
	ON_CBN_SELCHANGE(IDC_FILTER_COMBO, OnComboChange)
	//-------Folger 07/17/07 IMPLEMENT_DIALOG_FUNCTION
	ON_GRID_BUTTON_CLICK(IDC_SELECTED_LIST, OnButtonClickColList)
	ON_GRID_BEFORE_EDIT(IDC_SELECTED_LIST, OnBeforeEditParaControl)
	//-------End IMPLEMENT_DIALOG_FUNCTION
	ON_CONTEXTMENU(OnShowMenu)	///Jasmine 07/18/07 COLUMN_LIST_MENU
	//ON_GRID_ROW_COL_CHANGE(IDC_REPORT_TREE_LIST, OnListRowChange)//Jasmine 08/01/07 FIX_BUTTONS_ENABLE_ISSUE
	ON_GRID_SEL_CHANGE(IDC_REPORT_TREE_LIST, OnListRowChange)
	//------ Folger 08/09/07 SET_BOTTOM_PANEL_BY_ACTIVE_ORIOBJ_ONLY
	//ON_GRID_SEL_CHANGE(IDC_SELECTED_LIST, OnListSelectionChange)	//------Folger 07/19/07 ON_SELECTED_LIST_SELECTION_CHANGE
	//------ End SET_BOTTOM_PANEL_BY_ACTIVE_ORIOBJ_ONLY
	
	ON_GRID_AFTER_MOVE_ROWS(IDC_SELECTED_LIST, OnAfterMoveRows)		//------ Folger 08/02/07 UPDATE_RANGE_SELECTION_VECTOR_STRING_AFTER_DARG&DROP	
	ON_HELPINFO(OnHelp)
	/// Kenny 09/10/2009 QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
	ON_CBN_SELCHANGE(IDC_COMBO_INSERT_MODE, OnComboInsertModeChange)
	/// End QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
	EVENTS_END

	//------ fisher 11/15/07 ADD_MAP_ID_TO_CHM
	BOOL OnHelp(int &nHelpID, int nIdCtrlFocus)
	{
		nHelpID = IDD_DS_BROWSER_DLG;
		return true;
	}

	BOOL OnInitDialog()
	{
		Text = m_strDlgName;
		vector<string>  vstrTipsUpDown;
		vstrTipsUpDown.Add(_L("Show Selected Items"));
		vstrTipsUpDown.Add(_L("Hide Selected Items"));
		MultiPaneDlg::OnInitDialog(IDC_REPORT_TREE_LIST, IDC_SHOW_HIDE_BTN, IDC_SELECTED_LIST, vstrTipsUpDown, m_strDlgName, 0, NULL, 150);
		
		GetItem(IDC_LIST_TEXT).Visible = true;
		///------ Folger 06/01/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT
		//GetItem(IDC_FILTER_COMBO).Visible = true;
		BOOL	bIsBookSheetSpecified = !m_strBookSheetSpecified.IsEmpty();
		GetItem(IDC_FILTER_COMBO).Visible = !bIsBookSheetSpecified;
		Control		ctrlBookSheet = GetItem(IDC_BOOK_SHEET_SPECIFIED);
		if ( (ctrlBookSheet.Visible = bIsBookSheetSpecified) )
			ctrlBookSheet.Text = m_strBookSheetSpecified;
		///------ End DATA_DISPLAY_DIALOG_IMPROVEMENT
		//------ Folger 07/31/07 HIDE_FILTER_BUTTON
		//GetItem(IDC_FILTER_BTN).Visible = true;
		GetItem(IDC_FILTER_BTN).Visible = false;
		//------ End HIDE_FILTER_BUTTON
		GetItem(IDC_STATUS).Visible = true;		//-------Folger 07/19/07 ADD_STATUS_BAR_FOR_RANGE_BROWSER
		GetItem(IDC_EXCLUDE_BTN).Visible = true;
		GetItem(IDC_EXCLUDE_BTN).Text = _L("Exclude");

		/// Kenny 09/10/2009 QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
		initInsertModeCombo();
		/// End QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
		
		//------ Folger 10/26/07 CORRECT_NAME_SHOWN_IN_RANGE_BROWSER
		Control ctrlComboText = GetItem(IDC_LIST_TEXT);
		switch (m_nPageFilterType)
		{
		case EXIST_WKS:
			if (!m_bXYRange)
			{
				ctrlComboText.Text = _L("List Columns");
				m_strSelectedText = STR_COLUMN_SELECTED;
			}
			else
			{
				m_strSelectedText = STR_DATASET_SELECTED;
			}
			break;
		case EXIST_MATRIX:
			if (m_dwFilter == 0)
			{
				ctrlComboText.Text = _L("List Matrices");
				m_strSelectedText = STR_MATRIX_SELECTED;
			}
			else
			{
				ctrlComboText.Text = _L("List Images");
				m_strSelectedText = STR_IMAGE_SELECTED;
			}
			break;
		default:
			break;
		}
		//------ End CORRECT_NAME_SHOWN_IN_RANGE_BROWSER
		
		Page pg = Project.Pages();
		//------ Folger 08/23/07 FIX_BUGS_WHEN_PAGE_INVALID
		//int nPageType = pg.GetType();
		int nPageType = pg ? pg.GetType() : EXIST_WKS;
		//------ End FIX_BUGS_WHEN_PAGE_INVALID
		
		m_bResizeFirstTime = true;
		//InitPBList();	
		//InitRangeList();
		
		m_cmbList = GetItem(IDC_FILTER_COMBO);

		///Kyle 06/30/2009 RANGE_BROWSER_SHOULD_KEEP_LAST_SELECT_IN_FILTER_COMBO_BOX
#ifndef SET_VALUES_SUPPORT_DEFINE_VARIBLE
		///End RANGE_BROWSER_SHOULD_KEEP_LAST_SELECT_IN_FILTER_COMBO_BOX

		m_cmbList.InsertString(LIST_ALL_IN_PROJECT, _L("in Current Project"));
		m_cmbList.InsertString(LIST_ALL_IN_FOLDER, _L("in Current PE Folder"));
		///Sophy 6/17/2008 QA80-10415 SHOULD_HIDE_BOOK_AND_SHEET_ITEM_IN_COMBOLIST_WHEN_PLOT_DATA_TYPE_IS_VECTOR
		//m_cmbList.InsertString(LIST_ALL_IN_PAGE , _L("in Current Book"));
		//m_cmbList.InsertString(LIST_ALL_IN_LAYER, _L("in Current Sheet"));
		if( ( m_dwFilter & SCD_VECTOR_TYPE || m_dwFilter & SCD_NO_RESULT_SHEET ) && ( EXIST_GRAPH == nPageType ) );//should hide Book & Sheet Item in the combo list
		else
		{
			m_cmbList.InsertString(LIST_ALL_IN_PAGE , _L("in Current Book"));
			m_cmbList.InsertString(LIST_ALL_IN_LAYER, _L("in Current Sheet"));
		}
		///end SHOULD_HIDE_BOOK_AND_SHEET_ITEM_IN_COMBOLIST_WHEN_PLOT_DATA_TYPE_IS_VECTOR
		//-------Folger 07/19/07 SET_COMBO_LIST_CURRENT_SELECTED
		//int nSel = LIST_ALL_IN_FOLDER;
		//if(EXIST_WKS == nPageType)
			//nSel = LIST_ALL_IN_LAYER;
		bool bAddGraph = m_bXYRange && nPageType == EXIST_PLOT;
		int  nSel;
		if(m_bXYRange && hasPlotForm(m_vsSelection))
		{
			bAddGraph = true;
			nSel = LIST_ALL_IN_GRAPH;
		}
		else if (m_vsSelection.GetSize())
			nSel = LIST_ALL_IN_LAYER;
		else
		{
			switch(nPageType)
			{
			case EXIST_WKS:
				nSel = LIST_ALL_IN_LAYER;
				break;
			case EXIST_GRAPH:
				nSel = LIST_ALL_IN_GRAPH;
				break;
			default:
				nSel = LIST_ALL_IN_FOLDER;
				break;
			}
		}
		///Sophy 6/17/2008 QA80-10415 SHOULD_HIDE_BOOK_AND_SHEET_ITEM_IN_COMBOLIST_WHEN_PLOT_DATA_TYPE_IS_VECTOR
		if( !bAddGraph && ( m_dwFilter & SCD_VECTOR_TYPE || m_dwFilter & SCD_NO_RESULT_SHEET ) && ( EXIST_GRAPH == nPageType ) )
			nSel = LIST_ALL_IN_FOLDER;
		///end SHOULD_HIDE_BOOK_AND_SHEET_ITEM_IN_COMBOLIST_WHEN_PLOT_DATA_TYPE_IS_VECTOR

		//-------End SET_COMBO_LIST_CURRENT_SELECTED
		m_nListGraphOffset = 0;		//------ Folger 07/31/07 NOT_SHOW_BOOK_SHEET_WHEN_INIT_FROM_GRAPH
		if(bAddGraph)
		{
			//------ Folger 07/31/07 NOT_SHOW_BOOK_SHEET_WHEN_INIT_FROM_GRAPH
			//m_cmbList.InsertString(LIST_ALL_IN_GRAPH, _L("in Current Graph"));
			m_cmbList.DeleteString(LIST_ALL_IN_LAYER);
			m_cmbList.DeleteString(LIST_ALL_IN_PAGE);
			m_nListGraphOffset = LIST_ALL_IN_GRAPH - LIST_ALL_IN_PAGE;
			nSel -= m_nListGraphOffset;
			//------ Folger 11/13/07 FIX_BUG_OF_COMBO_LSIT_ARRANGEMENT_IN_DATASET_BROWSER
			//m_cmbList.InsertString(nSel, _L("in Current Graph"));
			m_cmbList.InsertString(LIST_ALL_IN_PAGE, _L("in Current Graph"));		//add as last combo string
			//------ End FIX_BUG_OF_COMBO_LSIT_ARRANGEMENT_IN_DATASET_BROWSER
			//------ End NOT_SHOW_BOOK_SHEET_WHEN_INIT_FROM_GRAPH
		}
		/// Iris 03/26/2009 QA80-13295-P3 GOTO_DLG_SUPPORT_COL_BROWSER
		if( m_dwFilter & SCD_ONLY_SELECTABLE_IN_LAYER )
		{			
			nSel = LIST_ALL_IN_LAYER;
			m_cmbList.Enable = false;
		}
		///end GOTO_DLG_SUPPORT_COL_BROWSER
		m_cmbList.SetCurSel(nSel);
		
		///Kyle 06/30/2009 RANGE_BROWSER_SHOULD_KEEP_LAST_SELECT_IN_FILTER_COMBO_BOX
#else // SET_VALUES_SUPPORT_DEFINE_VARIBLE
		initFilterCombo(nPageType);
#endif //SET_VALUES_SUPPORT_DEFINE_VARIBLE
		///End RANGE_BROWSER_SHOULD_KEEP_LAST_SELECT_IN_FILTER_COMBO_BOX

		OnComboChange(m_cmbList);
		InitRangeList();
		updateAddButton();///Jasmine 09/28/07 CHECK_SINGLE_SELECT_MODE
		//m_pPBList->SetDefaultShow(m_strDefaultShow);
		//------ Folger 10/26/07 CORRECT_NAME_SHOWN_IN_RANGE_BROWSER
		//updateStatusBar("Dataset Selected");	//------ Folger 08/09/07 SHOW_INFO_STRING_WHEN_NO_DATASET_SELECTED_IN_BOTTOM_PANEL
		updateStatusBar(m_strSelectedText);
		//------ End CORRECT_NAME_SHOWN_IN_RANGE_BROWSER
		return true;
	}
	BOOL OnDestroy()
	{
		if(m_pPBList) 
			m_pPBList->OnDestroy();	

		///Kyle 06/30/2009 RANGE_BROWSER_SHOULD_KEEP_LAST_SELECT_IN_FILTER_COMBO_BOX
#ifdef SET_VALUES_SUPPORT_DEFINE_VARIBLE
		saveFilterComboSel();
#endif //SET_VALUES_SUPPORT_DEFINE_VARIBLE
		///End RANGE_BROWSER_SHOULD_KEEP_LAST_SELECT_IN_FILTER_COMBO_BOX

		/// Kenny 09/10/2009 QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
		if ( m_bShowInsertMode )
		{
			int nInsertMode = m_comboInsertMode.GetCurSel();
			SaveSetting(STR_INSERTMODE, nInsertMode, STR_DLG_NAME);	
		}
		/// End QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
			
		return MultiPaneDlg::OnDestroy();
	}
	BOOL OnReady()
	{
		//UpdateDlgSize();
		UpdateDlgShow();
		SetInitReady();
		//-------Folger 07/17/07 IMPLEMENT_DIALOG_FUNCTION		
		GetItem(IDOK).Enable = m_vsSelection.GetSize();
		GetItem(IDC_ADD_BTN).Enable = GetItem(IDC_REMOVE_BTN).Enable =  GetItem(IDC_EXCLUDE_BTN).Enable = false;
		//-------End IMPLEMENT_DIALOG_FUNCTION
		return TRUE;
	}
	BOOL OnDlgResize(int nType, int cx, int cy)
	{	
		if(!IsInitReady())
			return TRUE;
		MoveControlsHelper	_temp(this);	///Jasmine 03/27/06 DLG_RESIZE_PAINT_MESS
		vector<uint> nButtonIDs = {IDCANCEL, IDOK, IDC_REMOVE_BTN, IDC_ADD_BTN, IDC_STATUS, 0};
		MultiPaneDlg::OnDlgResize(nButtonIDs, cx, cy, false);
		
		if(m_bResizeFirstTime)
		{
			int nEdge = GetControlGap();
			
			RECT rr;
			//------ Folger 08/03/07 STATUS_BAR_RESIZE_WHEN_DIALOG_RESIZE
			//GetClientRect(GetItem(IDC_STATUS), rr);
			//rr.left = nEdge;
			//MoveControl(GetItem(IDC_STATUS), rr);
			//------ End TUS_BAR_RESIZE_WHEN_DIALOG_RESIZE
			
			///------ Folger 06/01/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT
			int			nID = 0;
			Control		ctrlBookSheet = GetItem(IDC_BOOK_SHEET_SPECIFIED);
			if ( ctrlBookSheet.Visible )
			{
				nID = IDC_BOOK_SHEET_SPECIFIED;
				GetClientRect(ctrlBookSheet, rr);
				int		nWidth = 0;
				ctrlBookSheet.Measure(ctrlBookSheet.Text, &nWidth, TRUE);
				rr.right = rr.left + nWidth + 3 * nEdge;
				MoveControl(ctrlBookSheet, rr);
			}
			else
			{
				nID = IDC_FILTER_COMBO;
			///------ End DATA_DISPLAY_DIALOG_IMPROVEMENT
				GetClientRect(GetItem(IDC_FILTER_COMBO), rr);
				rr.right = rr.left + 150;
				MoveControl(GetItem(IDC_FILTER_COMBO), rr); 

			///------ Folger 06/01/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT
			}
			///------ End DATA_DISPLAY_DIALOG_IMPROVEMENT
			
			/// Kenny 09/10/2009 QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
			//vector<uint> vnGroup = {IDC_LIST_TEXT, IDC_FILTER_COMBO, IDC_EXCLUDE_BTN, IDC_FILTER_BTN, 0};
			vector<uint> vnGroup = {IDC_LIST_TEXT, IDC_FILTER_COMBO, IDC_EXCLUDE_BTN, IDC_FILTER_BTN, IDC_STATIC_INSERT_MODE, IDC_COMBO_INSERT_MODE, 0};
			/// End QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
			///------ Folger 06/01/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT
			vnGroup[1] = nID;
			///------ End DATA_DISPLAY_DIALOG_IMPROVEMENT
			int ny = ArrangeControlsLeftRight(vnGroup, nEdge, nEdge);
			GetClientRect(GetItem(IDC_REPORT_TREE_LIST), rr);
			rr.top = ny + nEdge;
			MoveControl(GetItem(IDC_REPORT_TREE_LIST), rr); 	
			
			m_bResizeFirstTime = false;
		}
		//------ Folger 08/03/07 STATUS_BAR_RESIZE_WHEN_DIALOG_RESIZE
		RECT rr;
		GetClientRect(GetItem(IDC_STATUS), rr);
		rr.left = GetControlGap();
		MoveControl(GetItem(IDC_STATUS), rr);
		//------ End STATUS_BAR_RESIZE_WHEN_DIALOG_RESIZE
		return TRUE;
	}
	BOOL OnInitSize()
	{
		return FALSE;
	}
	BOOL OnRestoreSize(DWORD dwSizeInfo)
	{
		void * p = (void*)dwSizeInfo;
		DLGSIZEINFO *pSz = (DLGSIZEINFO*)p;
		
		lstrcpyn(pSz->szDialogName, m_strDlgName, MAXLINE);
		
		SIZE sz;
		GetDlgOptimalSize(sz);
		pSz->top = -1;
		pSz->left = -1;
		pSz->width = 700;//sz.cx, hard code, temp
		pSz->height = 500;//sz.cy
		return TRUE;
	}
	BOOL OnComboChange(Control ctrl)
	{
		int nSel = m_cmbList.GetCurSel();
		//------ Folger 07/31/07 NOT_SHOW_BOOK_SHEET_WHEN_INIT_FROM_GRAPH
		if (m_nListGraphOffset != 0 && nSel > LIST_ALL_IN_FOLDER)
			nSel += m_nListGraphOffset;
		//------ End NOT_SHOW_BOOK_SHEET_WHEN_INIT_FROM_GRAPH
		
		///Jasmine 04/20/10 QA81-15333-P2 PBLIST_IS_INVALID_IF_NO_INIT_AND_LEAD_TO_RUNTIME_ERR
		//if(m_nSel != nSel)
		if(m_nSel != nSel || nSel == -1)
		{
			ASSERT(nSel != -1);
			InitPBList(nSel);
		}
		///End PBLIST_IS_INVALID_IF_NO_INIT_AND_LEAD_TO_RUNTIME_ERR
		
		m_nSel = nSel;
		UpdateList(nSel);
		GetItem(IDC_ADD_BTN).Enable = false;
		return TRUE;
	}
	/// Kenny 09/10/2009 QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
	BOOL OnComboInsertModeChange(Control ctrl)
	{
		updateInsertMode();
		return TRUE;
	}
	/// End QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
	BOOL OnFilter(Control ctrl)
	{
		FilterEditDlg filterDlg();
		if(IDOK == filterDlg.DoModalEx(GetSafeHwnd()))
		{
			string strFilter = filterDlg.GetText();
			if(ocu_get_correct_LT_expression(strFilter, &strFilter))
			{
				//doing..
			}
		}
		return TRUE;
	}
	BOOL OnExclude(Control ctrl)
	{
		excludeSelected();
		return TRUE;
	}
	//-------Folger 07/17/07 IMPLEMENT_DIALOG_FUNCTION
	BOOL OnAdd(Control ctrl)
	{
		addSelected();
		return TRUE;
	}
	BOOL OnRemove(Control ctrl)
	{
		removeSelected();
		return TRUE;
	}
	void OnDoubleClick(Control ctrl)
	{
		addSelected();
	}
	void OnButtonClickColList(Control flxControl, int nRow, int nCol)
	{
		m_pRangeList->OnButtonClick(flxControl, nRow, nCol);
		vector<string> vsVals;
		m_pRangeList->GetColValues(COL_RANGE + m_pRangeList->GetColOffset(), vsVals, m_pRangeList->GetRowOffset());
		m_vsSelection = vsVals;
	}
	void OnBeforeEditParaControl(Control flxControl, long nRow, long nCol, BOOL* pCancel)
	{
		m_pRangeList->OnBeforeEditParaControl(flxControl, nRow, nCol,pCancel );
		GetItem(IDC_REMOVE_BTN).Enable = true;
		//------ Folger 08/09/07 UPDATE_STATUS_BAR_WHEN_SELECTION_CHANGE
		////-------Folger 07/19/07 ADD_STATUS_BAR_FOR_RANGE_BROWSER
		//string strRange;
		//m_pRangeList->GetSelection(strRange);
		//m_pRangeList->ConvertDataPlotRange(strRange);
		//Edit edit = GetItem(IDC_STATUS);
		//edit.SetSel(0, -1);
		//edit.ReplaceSel(strRange);
		updateStatusBarOnSelectionChange();
		////-------End ADD_STATUS_BAR_FOR_RANGE_BROWSER
		//------ Folger 08/09/07 UPDATE_STATUS_BAR_WHEN_SELECTION_CHANGE
	}
	//-------End IMPLEMENT_DIALOG_FUNCTION
	///Jasmine 07/18/07 COLUMN_LIST_MENU
	BOOL OnShowMenu(UINT nResIDCtrl, int nx, int ny)
	{
		if(IDC_REPORT_TREE_LIST != nResIDCtrl)
			return TRUE;
		return m_pPBList->ShowMenu(nx, ny);
	}
	///End COLUMN_LIST_MENU
	void OnListRowChange(Control ctrl)
	{
		if(m_pPBList && m_pPBList->GetSelectedRow() >= m_pPBList->GetRowOffset())
			GetItem(IDC_ADD_BTN).Enable = GetItem(IDC_EXCLUDE_BTN).Enable = true;
	}
	
	//------ Folger 08/09/07 SET_BOTTOM_PANEL_BY_ACTIVE_ORIOBJ_ONLY
	////------Folger 07/19/07 ON_SELECTED_LIST_SELECTION_CHANGE
	//void OnListSelectionChange(Control ctrl)
	//{
		////------ Folger 07/26/07 FIX_BUGS_IN_REFRESH_TOP_PANEL
		////if (m_cmbList)
			////UpdateList(m_cmbList.GetCurSel());
		//if (!m_cmbList) return;
		//string strRange;
		//m_pRangeList->GetSelection(strRange);
		//string strBook, strSheet;
		//string strOldBook, strOldSheet;
		//okutil_get_book_sheet_info(&strBook, &strSheet, strRange);
		//okutil_get_book_sheet_info(&strOldBook, &strOldSheet, m_strOldRange);
		//int nSel = m_cmbList.GetCurSel();
		////------ Folger 07/31/07 NOT_SHOW_BOOK_SHEET_WHEN_INIT_FROM_GRAPH
		//if (m_nListGraphOffset != 0 && nSel > LIST_ALL_IN_FOLDER)
			//nSel += m_nListGraphOffset;
		////------ End NOT_SHOW_BOOK_SHEET_WHEN_INIT_FROM_GRAPH
		//if (nSel == LIST_ALL_IN_PAGE && strBook.CompareNoCase(strOldBook) ||
			//nSel == LIST_ALL_IN_LAYER && (strBook.CompareNoCase(strOldBook) || strSheet.CompareNoCase(strOldSheet)) ||
			//nSel == LIST_ALL_IN_GRAPH && strBook.CompareNoCase(strOldBook))
			//{
				//UpdateList(nSel);
				//m_strOldRange = strRange;
			//}
		////------ End FIX_BUGS_IN_REFRESH_TOP_PANEL
	//}
	////------End ON_SELECTED_LIST_SELECTION_CHANGE
	//------ End SET_BOTTOM_PANEL_BY_ACTIVE_ORIOBJ_ONLY
	
	//------ Folger 08/02/07 UPDATE_RANGE_SELECTION_VECTOR_STRING_AFTER_DARG&DROP
	void OnAfterMoveRows(Control ctrl, long nRow, long *pnPosition)
	{
		vector<string> vsVals;
		m_pRangeList->GetColValues(COL_RANGE + m_pRangeList->GetColOffset(), vsVals, m_pRangeList->GetRowOffset());
		m_vsSelection = vsVals;
	}
	//------ End UPDATE_RANGE_SELECTION_VECTOR_STRING_AFTER_DARG&DROP
	bool InitRangeList()
	{
		if(m_pRangeList)
			return true;
		//-------Folger 07/17/07 IMPLEMENT_DIALOG_FUNCTION
		switch(m_nPageFilterType)
		{
		case EXIST_WKS:
			m_pRangeList = new ColumnRangeList();
			m_pRangeList->Init(IDC_SELECTED_LIST, *this);
			break;
		case EXIST_MATRIX:
			m_pRangeList = new MatObjRangeList();
			m_pRangeList->Init(IDC_SELECTED_LIST, *this);
			break;
		default:
			return error_report("Initializing Range List fail!");
		}
		//-------End IMPLEMENT_DIALOG_FUNCTION		
		if(m_vsSelection.GetSize())
		{
			vector<string> vsVals;
			vsVals = m_vsSelection;
			m_pPBList->GetInitRangeString(vsVals);//convert to standard range
			for (int ii=0; ii<vsVals.GetSize(); ii++)
			{
				if (vsVals[ii].IsEmpty())
				{
					vsVals.RemoveAt(ii);
					ii--;
				}
			}
			//m_strDefaultShow = vsVals[0];
			int nRowStart = m_pRangeList->GetRows();
			int nSize = vsVals.GetSize();
			for(ii=0; ii<nSize; ii++)
				m_pRangeList->AddRow(nRowStart++, vsVals[ii]);
			m_pRangeList->ResizeCols();
			m_vsSelection = vsVals;
		}
		return true;
	}
	bool InitPBList(int nSel)
	{
		if(!ConstructListPointer(nSel))
			return false;
		m_pPBList->Init(IDC_REPORT_TREE_LIST, *this, m_strDlgName, m_nPageFilterType);
		m_pPBList->SetSelectMode(m_nSelectMode);
		///Jasmine 07/18/07 SET_SHOW_COLUMN_WITH_VECTOR_UINT
		vector<uint> vnDisplayCols = {	PEOBJECT_LAYER,	
										PEOBJECT_INDEX,
										PEOBJECT_SNAME, 
										PEOBJECT_LNAME,
										PEOBJECT_COMMENTS,
										PEOBJECT_DESIGNATION,
										PEOBJECT_FORMAT,
										PEOBJECT_SIZE,
										PEOBJECT_FIRSTVALUE,	//------ Folger 07/26/07 ADD_FIRSTVALUE_IN_OBJECT_LIST
										PEOBJECT_PARAM,	
										PEOBJECT_UDL
									 };
		//------Folger 07/25/07 UNIFY_PBLIST_MENU_BY_ADD_LOWERBOUND_AND_UPPERBOUND
		//m_pPBList->SetShowColumns(vnDisplayCols);//SHOW_LAYER_NAME);		//-------Folger 07/17/07 IMPLEMENT_DIALOG_FUNCTION
		if (nSel == LIST_ALL_IN_GRAPH)
			m_pPBList->SetShowColumns();
		else
			m_pPBList->SetShowColumns(vnDisplayCols);
		//------End UNIFY_PBLIST_MENU_BY_ADD_LOWERBOUND_AND_UPPERBOUND
		///End SET_SHOW_COLUMN_WITH_VECTOR_UINT
		if(PB_BROWSER_OBJECT_LIST == m_pPBList->GetPBListType())
			m_pPBList->SetShowXYRange(m_bXYRange);
		m_pPBList->SetShowFilter(m_dwFilter);//m_pPBList->SetShowResultSheet(m_bResultSheet);	///Jasmine 09/28/07 FILTER_OUT_NON_IMAGE_MATRIX	
		return true;
	}
	bool ConstructListPointer(int nSel)
	{	
		///Jasmine 07/23/07 ADD_PLOT_LIST_CLASS	
		//if(m_pPBList)
			//return true;
		//------ Folger 08/01/07 SAVE_HIDE_COLS_WHEN_DATASET_TAB_CHANGE
		if (m_pPBList)
			m_pPBList->SaveHideCols();
		//------ End SAVE_HIDE_COLS_WHEN_DATASET_TAB_CHANGE
		m_pPBList = NULL;
		string strClass;
		switch(nSel)
		{
		case LIST_ALL_IN_GRAPH:
			strClass = "PBPlotList";
			break;
		default:
			strClass = "PBObjectList";
			break;
		}
		///End ADD_PLOT_LIST_CLASS	
		PBListBase& PBList = (PBListBase&) Project.FindClass(strClass);
		m_pPBList = &PBList;
		if(m_pPBList == NULL)
			return false;
		return true;
	}
	bool UpdateList(int nSel)
	{
		Page pg;
		///Sophy CLEAN_CODE_PBLIST_CONTROL
		//m_pPBList->UpdateList(pg);//to reset the grid
		vector<string>	vsItems;
		vector<int>		vnPageType;
		vector<DWORD> 	vdwStatus;//vector<bool> vdwStatus;	///Jasmine 04/27/10 QA81-14826-P5 COMBINE_BOOL_IN_DWORD_TO_SIMPLIFY_FUNC_INTERFACE
		m_pPBList->GetItems( pg, vsItems, vnPageType, vdwStatus );
		m_pPBList->UpdateList( vsItems, vnPageType, vdwStatus );
		
		vsItems.RemoveAll();
		vnPageType.RemoveAll();
		vdwStatus.RemoveAll();
		///end Sophy CLEAN_CODE_PBLIST_CONTROL
		string strRange;
		if(NULL == m_pRangeList)
			InitRangeList();
		m_pRangeList->GetSelection(strRange);	
		
		///------ Folger 06/01/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT
		if ( !m_strBookSheetSpecified.IsEmpty() )
		{
			Worksheet	ds;
			okxf_resolve_string_get_origin_object(m_strBookSheetSpecified, &ds);
			if ( ds )
			{
				m_pPBList->GetItems( ds, vsItems, vnPageType, vdwStatus );
				m_pPBList->UpdateList( vsItems, vnPageType, vdwStatus );
				return true;
			}
		}
		///------ End DATA_DISPLAY_DIALOG_IMPROVEMENT
		
		switch(nSel)
		{
		case LIST_ALL_IN_PROJECT:
		case LIST_ALL_IN_FOLDER:
			Folder 	fld = LIST_ALL_IN_FOLDER == nSel? Project.ActiveFolder() : Project.RootFolder;
			///Sophy CLEAN_CODE_PBLIST_CONTROL
			//if(fld)
				//m_pPBList->UpdateList(fld, m_nPageFilterType, true);
			if( fld )
			{
				m_pPBList->GetItems( fld, vsItems, vnPageType, vdwStatus, m_nPageFilterType, true );
				m_pPBList->UpdateList( vsItems, vnPageType, vdwStatus );
			}
			///end  Sophy CLEAN_CODE_PBLIST_CONTROL
			break;
		case LIST_ALL_IN_PAGE:
		case LIST_ALL_IN_LAYER:
			//------ Folger 08/09/07 SET_BOTTOM_PANEL_BY_ACTIVE_ORIOBJ_ONLY
			//string strSheet;
			//string strBook = getPage(strRange, &strSheet);
			//Datasheet ds;
			//Page pgBook(strBook);
			//if(pgBook && EXIST_PLOT != pgBook.GetType())
				//ds = pgBook.Layers(strSheet);
			//if(!ds)
			//{
				//m_pRangeList->ConvertDataPlotRange(strRange);
				//strBook = getPage(strRange, &strSheet);
				//Page pSource(strBook);
				//if(pSource)
					//ds = pSource.Layers(strSheet);
			//}
			//if(!ds)
				//ds = Project.ActiveLayer();
			Datasheet ds;
			ds = Project.ActiveLayer();
			//------ End SET_BOTTOM_PANEL_BY_ACTIVE_ORIOBJ_ONLY
			if(ds)
				pg = ds.GetPage();
			if(!pg)
				return false;
			if(m_nPageFilterType == pg.GetType())
			{
				///Sophy CLEAN_CODE_PBLIST_CONTROL
				/*
				if(LIST_ALL_IN_PAGE == nSel)
					m_pPBList->UpdateList(pg);
				if(LIST_ALL_IN_LAYER == nSel)
					m_pPBList->UpdateList(ds);
				*/
				if(LIST_ALL_IN_PAGE == nSel)
					m_pPBList->GetItems( pg, vsItems ,vnPageType, vdwStatus );
				else if(LIST_ALL_IN_LAYER == nSel)
					m_pPBList->GetItems( ds, vsItems, vnPageType, vdwStatus );
				
				m_pPBList->UpdateList( vsItems, vnPageType, vdwStatus );
				///end Sophy CLEAN_CODE_PBLIST_CONTROL
				
			}
			break;
		case LIST_ALL_IN_GRAPH:	
			string strBook = getPage(strRange);
			GraphPage gp(strBook);
			if(!gp)
				gp = Project.Pages();
			//m_pPBList->UpdateListWithGraph(gp, m_nPageFilterType);
			/*
			if(gp)
				///Sophy CLEAN_CODE_PBLIST_CONTROL
				m_pPBList->UpdateList(gp);
			*/
			if( gp )
			{
				m_pPBList->GetItems( gp, vsItems, vnPageType, vdwStatus );
				m_pPBList->UpdateList( vsItems, vnPageType, vdwStatus );
			}
			///end CLEAN_CODE_PBLIST_CONTROL
			break;
		default:
			return false;
		}
		return true;
	}
private:
	///Kyle 06/30/2009 RANGE_BROWSER_SHOULD_KEEP_LAST_SELECT_IN_FILTER_COMBO_BOX
#ifdef SET_VALUES_SUPPORT_DEFINE_VARIBLE
	// centralize code, moved from OnInitDialog
	void initFilterCombo(int nPageType)
	{
		m_strCurFilterComboType = "FilterComboPFBS";								///Kyle 06/30/2009 RANGE_BROWSER_SHOULD_KEEP_LAST_SELECT_IN_FILTER_COMBO_BOX
		m_cmbList.InsertString(LIST_ALL_IN_PROJECT, _L("in Current Project"));
		m_cmbList.InsertString(LIST_ALL_IN_FOLDER, _L("in Current PE Folder"));
		///Sophy 6/17/2008 QA80-10415 SHOULD_HIDE_BOOK_AND_SHEET_ITEM_IN_COMBOLIST_WHEN_PLOT_DATA_TYPE_IS_VECTOR
		//m_cmbList.InsertString(LIST_ALL_IN_PAGE , _L("in Current Book"));
		//m_cmbList.InsertString(LIST_ALL_IN_LAYER, _L("in Current Sheet"));
		if( ( m_dwFilter & SCD_VECTOR_TYPE || m_dwFilter & SCD_NO_RESULT_SHEET ) && ( EXIST_GRAPH == nPageType ) )	//should hide Book & Sheet Item in the combo list
		{
			m_strCurFilterComboType = "FilterComboPF";					///Kyle 06/30/2009 RANGE_BROWSER_SHOULD_KEEP_LAST_SELECT_IN_FILTER_COMBO_BOX
		}
		else
		{
			m_cmbList.InsertString(LIST_ALL_IN_PAGE , _L("in Current Book"));
			m_cmbList.InsertString(LIST_ALL_IN_LAYER, _L("in Current Sheet"));
		}
		///end SHOULD_HIDE_BOOK_AND_SHEET_ITEM_IN_COMBOLIST_WHEN_PLOT_DATA_TYPE_IS_VECTOR
		//-------Folger 07/19/07 SET_COMBO_LIST_CURRENT_SELECTED
		//int nSel = LIST_ALL_IN_FOLDER;
		//if(EXIST_WKS == nPageType)
			//nSel = LIST_ALL_IN_LAYER;
		bool bAddGraph = m_bXYRange && nPageType == EXIST_PLOT;
		int  nSel;
		if(m_bXYRange && hasPlotForm(m_vsSelection))
		{
			bAddGraph = true;
			nSel = LIST_ALL_IN_GRAPH;
		}
		else if (m_vsSelection.GetSize())
			nSel = LIST_ALL_IN_LAYER;
		else
		{
			switch(nPageType)
			{
			case EXIST_WKS:
				nSel = LIST_ALL_IN_LAYER;
				break;
			case EXIST_GRAPH:
				nSel = LIST_ALL_IN_GRAPH;
				break;
			default:
				nSel = LIST_ALL_IN_FOLDER;
				break;
			}
		}
		///Sophy 6/17/2008 QA80-10415 SHOULD_HIDE_BOOK_AND_SHEET_ITEM_IN_COMBOLIST_WHEN_PLOT_DATA_TYPE_IS_VECTOR
		if( !bAddGraph && ( m_dwFilter & SCD_VECTOR_TYPE || m_dwFilter & SCD_NO_RESULT_SHEET ) && ( EXIST_GRAPH == nPageType ) )
			nSel = LIST_ALL_IN_FOLDER;
		///end SHOULD_HIDE_BOOK_AND_SHEET_ITEM_IN_COMBOLIST_WHEN_PLOT_DATA_TYPE_IS_VECTOR

		//-------End SET_COMBO_LIST_CURRENT_SELECTED
		m_nListGraphOffset = 0;		//------ Folger 07/31/07 NOT_SHOW_BOOK_SHEET_WHEN_INIT_FROM_GRAPH
		if(bAddGraph)
		{
			m_strCurFilterComboType = "FilterComboPFG";					///Kyle 06/30/2009 RANGE_BROWSER_SHOULD_KEEP_LAST_SELECT_IN_FILTER_COMBO_BOX
			//------ Folger 07/31/07 NOT_SHOW_BOOK_SHEET_WHEN_INIT_FROM_GRAPH
			//m_cmbList.InsertString(LIST_ALL_IN_GRAPH, _L("in Current Graph"));
			m_cmbList.DeleteString(LIST_ALL_IN_LAYER);
			m_cmbList.DeleteString(LIST_ALL_IN_PAGE);
			m_nListGraphOffset = LIST_ALL_IN_GRAPH - LIST_ALL_IN_PAGE;
			nSel -= m_nListGraphOffset;
			//------ Folger 11/13/07 FIX_BUG_OF_COMBO_LSIT_ARRANGEMENT_IN_DATASET_BROWSER
			//m_cmbList.InsertString(nSel, _L("in Current Graph"));
			m_cmbList.InsertString(LIST_ALL_IN_PAGE, _L("in Current Graph"));		//add as last combo string
			//------ End FIX_BUG_OF_COMBO_LSIT_ARRANGEMENT_IN_DATASET_BROWSER
			//------ End NOT_SHOW_BOOK_SHEET_WHEN_INIT_FROM_GRAPH
		}
		/// Iris 03/26/2009 QA80-13295-P3 GOTO_DLG_SUPPORT_COL_BROWSER
		if( m_dwFilter & SCD_ONLY_SELECTABLE_IN_LAYER )
		{
			///Jasmine 04/20/10 QA81-15333-P2 CHECK_AND_ADD_COMBO_ITEM_TO_SELECT
			string strTemp;			
			m_cmbList.GetLBText(LIST_ALL_IN_PAGE, strTemp);
			if( strTemp.IsEmpty() )
				m_cmbList.InsertString(LIST_ALL_IN_PAGE , _L("in Current Book"));
			
			strTemp = "";
			m_cmbList.GetLBText(LIST_ALL_IN_LAYER, strTemp);
			if( strTemp.IsEmpty() )
				m_cmbList.InsertString(LIST_ALL_IN_LAYER, _L("in Current Sheet"));
			///End CHECK_AND_ADD_COMBO_ITEM_TO_SELECT
			m_strCurFilterComboType = "";			///Kyle 06/30/2009 RANGE_BROWSER_SHOULD_KEEP_LAST_SELECT_IN_FILTER_COMBO_BOX, no need to keep the setting
			nSel = LIST_ALL_IN_LAYER;
			m_cmbList.Enable = false;
		}
		///end GOTO_DLG_SUPPORT_COL_BROWSER

		///Kyle 06/30/2009 RANGE_BROWSER_SHOULD_KEEP_LAST_SELECT_IN_FILTER_COMBO_BOX
		if(!m_strCurFilterComboType.IsEmpty())
		{
			int nLastSel = LoadSetting(m_strCurFilterComboType, nSel, STR_DLG_NAME);
			if(nLastSel >= 0 || nLastSel < m_cmbList.GetCount() )
				nSel = nLastSel;
		}
		///End RANGE_BROWSER_SHOULD_KEEP_LAST_SELECT_IN_FILTER_COMBO_BOX

		m_cmbList.SetCurSel(nSel);
	}
	
	void saveFilterComboSel()
	{
		if(!m_strCurFilterComboType.IsEmpty())
			SaveSetting(m_strCurFilterComboType, m_cmbList.GetCurSel(), STR_DLG_NAME);
	}
#endif //SET_VALUES_SUPPORT_DEFINE_VARIBLE
	///End RANGE_BROWSER_SHOULD_KEEP_LAST_SELECT_IN_FILTER_COMBO_BOX

	bool hasPlotForm(vector<string> vsRange)
	{
		bool bPlotForm;
		int nSize = vsRange.GetSize();
		for(int ii = 0; ii < nSize; ii++)
		{
			string strBook = getPage(vsRange[ii]);
			GraphPage gp(strBook);
			if(gp)
			{
				bPlotForm = true;
				break;
			}
		}
		return bPlotForm;
	}
	string getPage(LPCSTR lpcszRange, string* pstrSheet = NULL)
	{
		string strBook, strSheet, strCol;
		okutil_parse_complete_range_string(lpcszRange, strBook, strSheet, strCol);
		if(pstrSheet)
			*pstrSheet = strSheet;
		return strBook;
	}
	/// Kenny 09/10/2009 QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
	void updateInsertMode()
	{
		m_nInsertMode = m_comboInsertMode.GetCurSel();
	}
	void initInsertModeCombo()
	{
		m_comboInsertMode = GetItem(IDC_COMBO_INSERT_MODE);
		m_comboInsertMode.Visible = m_bShowInsertMode;
		GetItem(IDC_STATIC_INSERT_MODE).Visible = m_bShowInsertMode;
		if ( m_bShowInsertMode )
		{
			m_comboInsertMode.ResetContent();
			vector<string> vsItems;
			vsItems.Add( STR_INSERT_MODE_NAME );
			vsItems.Add( STR_INSERT_MODE_INDEX );
			for( int ii = 0; ii < vsItems.GetSize(); ii++ )
				m_comboInsertMode.AddString(vsItems[ii]);

			int nInsertMode = INSERT_MODE_NAME;
			nInsertMode = LoadSetting(STR_INSERTMODE, nInsertMode, STR_DLG_NAME);
			m_comboInsertMode.SetCurSel(nInsertMode);

			m_comboInsertMode.SetDroppedVisibleItemCount();	/// Kenny 09/18/2009 INSERT_MODE_COMBO_TOO_NARROW
		}
		updateInsertMode();
	}
	/// End QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
	///Jasmine 09/28/07 CHECK_SINGLE_SELECT_MODE
	void updateAddButton()
	{
		if(SINGLE_SELECT == m_nSelectMode)
			///------ Folger 10/28/09 SPECIFY_LOCALIZATION_CATEGORY_FOR_RANGE_BROWSER
			//GetItem(IDC_ADD_BTN).Text = m_pRangeList->HasRows()? _L("Replace") : _L("Add");
			GetItem(IDC_ADD_BTN).Text = m_pRangeList->HasRows()? STR_REPLACE : STR_ADD;
			///------ End SPECIFY_LOCALIZATION_CATEGORY_FOR_RANGE_BROWSER
	}
	///End CHECK_SINGLE_SELECT_MODE
	//-------Folger 07/17/07 IMPLEMENT_DIALOG_FUNCTION
	void addSelected()
	{
		vector<string> vsSelected;
		vector<string> vsVals;
		///Jasmine 09/28/07 CHECK_SINGLE_SELECT_MODE
		int nSelRow = -1;
		if(SINGLE_SELECT == m_nSelectMode && m_pRangeList->HasRows())
		{
			nSelRow = m_pRangeList->GetSelectedRow();
			m_pRangeList->ClearAll();
		}
		///End CHECK_SINGLE_SELECT_MODE
		m_pPBList->GetSelectionRangeString(vsSelected);
		//------Folger 07/17/07 CLEAN_UP_DUPLICATED_CODES_IN_PROJECT_BROWSER_RANGE_BROWSER
		m_pRangeList->AddRows(vsSelected, vsVals);
		if (vsSelected.GetSize())
		//------End CLEAN_UP_DUPLICATED_CODES_IN_PROJECT_BROWSER_RANGE_BROWSER
			m_vsSelection = vsVals;
		GetItem(IDOK).Enable = m_vsSelection.GetSize();
		///Jasmine 09/28/07 CHECK_SINGLE_SELECT_MODE
		if(nSelRow >= m_pRangeList->GetRowOffset())
			m_pRangeList->SelRow(nSelRow);
		updateAddButton();
		///End CHECK_SINGLE_SELECT_MODE
	}
		
	void removeSelected()
	{
		//------Folger 07/17/07 CLEAN_UP_DUPLICATED_CODES_IN_PROJECT_BROWSER_RANGE_BROWSER
		vector<string> vsVals;
		m_pRangeList->RemoveSelectedRows(vsVals);
		//------End CLEAN_UP_DUPLICATED_CODES_IN_PROJECT_BROWSER_RANGE_BROWSER
		m_vsSelection = vsVals;
		updateStatusBarOnSelectionChange();		//------ Folger 08/09/07 UPDATE_STATUS_BAR_WHEN_SELECTION_CHANGE
		//------ Folger 08/09/07 SHOW_INFO_STRING_WHEN_NO_DATASET_SELECTED_IN_BOTTOM_PANEL
		//GetItem(IDC_REMOVE_BTN).Enable = GetItem(IDOK).Enable = m_vsSelection.GetSize();
		bool bRemoveEnable;
		bRemoveEnable = GetItem(IDC_REMOVE_BTN).Enable = GetItem(IDOK).Enable = m_vsSelection.GetSize();
		//------ Folger 10/26/07 CORRECT_NAME_SHOWN_IN_RANGE_BROWSER
		//if (!bRemoveEnable)
			//updateStatusBar("Dataset Selected");
		//------ End CORRECT_NAME_SHOWN_IN_RANGE_BROWSER
		//------ End SHOW_INFO_STRING_WHEN_NO_DATASET_SELECTED_IN_BOTTOM_PANEL
		updateAddButton();///Jasmine 09/28/07 CHECK_SINGLE_SELECT_MODE
	}
	//-------End IMPLEMENT_DIALOG_FUNCTION
	void excludeSelected()
	{
		vector<string> vsVals;
		m_pPBList->RemoveSelectedRows(vsVals);
		///Jasmine 08/01/07 FIX_BUTTONS_ENABLE_ISSUE
		vector<uint> vnRows;
		m_pPBList->GetSelRows(vnRows);
		GetItem(IDC_EXCLUDE_BTN).Enable = GetItem(IDC_ADD_BTN).Enable = vnRows.GetSize();
		///End FIX_BUTTONS_ENABLE_ISSUE
	}
	//-------Folger 07/24/07 CLEAN_UP_DATAPLOT_RANGE_STRING_CODE
	//-------Folger 07/19/07 ADD_STATUS_BAR_FOR_RANGE_BROWSER
	//void convertDataPlotRange(string &strRange)
	//{
		//string strPage, strLayer, strObj;
		//okutil_parse_complete_range_string(strRange, &strPage, &strLayer, &strObj);
		//GraphPage gp(strPage);
		//GraphLayer gl;
		//if (gp)
			//gl = gp.Layers(strLayer);
		//if (gl)
		//{
			////int nIndex = atoi(strObj) - 1;
			//int nIndex = _get_index_from_plot_range_string(strObj) - 1;
			//DataPlot dp = gl.DataPlots(nIndex);
			////if (dp)
			////{
				////XYRange drXY;
				////dp.GetDataRange(drXY);
				////int r1, c1, r2, c2;
				////Worksheet wks;
				////if(drXY)
					////drXY.GetRange("Y", r1, c1, r2, c2, wks);
				////string dsXName, dsYName;
				////if(wks)
					////dsYName = wks.Columns(c1).GetName();
				////Curve crv(wks, c1);
				////if(crv.HasX(dsXName))
				////{
					////nIndex = dsXName.Find('_');
					////if(0 <= nIndex)
						////dsXName = dsXName.Mid(nIndex + 1);
				////}
				////string strWks;
				////wks.GetRangeString(strWks);
				////strRange.Format(STR_RANGE_FORMAT, strWks, dsXName, dsYName);
			////}
			//strRange = get_content(dp);
		//}
	//}
	//-------End ADD_STATUS_BAR_FOR_RANGE_BROWSER
	//-------End CLEAN_UP_DATAPLOT_RANGE_STRING_CODE
	
	//------ Folger 08/09/07 UPDATE_STATUS_BAR_WHEN_SELECTION_CHANGE
	void updateStatusBar(string strInfo)
	{
		Edit edit = GetItem(IDC_STATUS);
		edit.SetSel(0, -1);
		//------ Folger 10/26/07 CORRECT_NAME_SHOWN_IN_RANGE_BROWSER
		//edit.ReplaceSel(strInfo);
		edit.ReplaceSel(strInfo.IsEmpty() ? m_strSelectedText : strInfo);
		//------ End CORRECT_NAME_SHOWN_IN_RANGE_BROWSER
	}
	
	void updateStatusBarOnSelectionChange()
	{
		string strRange;
		m_pRangeList->GetSelection(strRange);
		m_pRangeList->ConvertDataPlotRange(strRange);
		updateStatusBar(strRange);
	}
	//------ End UPDATE_STATUS_BAR_WHEN_SELECTION_CHANGE
	
private:
	/// Kenny 09/10/2009 QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
	ComboBox	m_comboInsertMode;
	int			m_nInsertMode;
	bool		m_bShowInsertMode;
	/// End QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
	ComboBox  	m_cmbList;
	PBListBase 	*m_pPBList;
	PBRangeListBase *m_pRangeList;		//-------Folger 07/17/07 IMPLEMENT_DIALOG_FUNCTION
	vector<string> m_vsSelection;
	string		m_strDlgName;
	//string		m_strDefaultShow;
	int			m_nSel;
	int			m_nPageFilterType;
	int			m_nSelectMode;
	bool 		m_bResizeFirstTime;
	bool 		m_bXYRange;
	DWORD       m_dwFilter;//bool 		m_bResultSheet;///Jasmine 09/28/07 FILTER_OUT_NON_IMAGE_MATRIX	
	string		m_strOldRange;
	int			m_nListGraphOffset;		//------ Folger 07/31/07 NOT_SHOW_BOOK_SHEET_WHEN_INIT_FROM_GRAPH
	string		m_strSelectedText;		//------ Folger 10/26/07 CORRECT_NAME_SHOWN_IN_RANGE_BROWSER
	///Kyle 06/30/2009 RANGE_BROWSER_SHOULD_KEEP_LAST_SELECT_IN_FILTER_COMBO_BOX
#ifdef SET_VALUES_SUPPORT_DEFINE_VARIBLE
	string		m_strCurFilterComboType;
#endif //SET_VALUES_SUPPORT_DEFINE_VARIBLE
	///End RANGE_BROWSER_SHOULD_KEEP_LAST_SELECT_IN_FILTER_COMBO_BOX

	///------ Folger 06/01/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT
	string		m_strBookSheetSpecified;
	///------ End DATA_DISPLAY_DIALOG_IMPROVEMENT
};

#endif//_RANGE_BROWSER_H
